//
//  FNOptionParserResultItem.h
//  OptionParser
//
//  Created by Heiko Witte on 13.12.16.
//  Copyright © 2016 fournova Software GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@class FNOption;
@class FNOptionCommand;
@interface FNOptionParserResultItem : NSObject
@property (nonatomic, nullable) FNOption *option;
@property (nonatomic, nullable) FNOptionCommand *command;
@property (nonatomic, nullable) id value;
@property (nonatomic, nullable) NSString *argument;

+ (nullable instancetype)resultWithArgument:(nonnull NSString *)argument;
+ (nullable instancetype)resultWithCommand:(nonnull FNOptionCommand *)command;
+ (nullable instancetype)resultWithOption:(nonnull FNOption *)option;
+ (nullable instancetype)resultWithOption:(nonnull FNOption *)option value:(nonnull id)value;

- (nullable id)initWithOption:(nullable FNOption *)option value:(nullable id)value argument:(nullable NSString *)argument;
- (nullable id)initWithCommand:(nullable FNOptionCommand *)command;
@end
