//
//  FNGitSequence.h
//  FNGit
//
//  Created by Alexander Rinass on 18/08/16.
//  Copyright © 2016 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@class FNGitSequenceInstruction;
@interface FNGitSequenceEditor : NSObject
@property (nonatomic, nonnull, readonly) NSArray<FNGitSequenceInstruction *> *sequenceInstructions;
@property (nonatomic, nonnull, readonly) NSString *stringValue;

+ (BOOL)createGitSequenceEditorScriptAtURL:(nonnull NSURL *)fileURL sequenceInstructions:(nonnull NSArray<FNGitSequenceInstruction *> *)sequenceInstructions error:(NSError * _Nullable __autoreleasing * _Nullable)error;

+ (nullable instancetype)new NS_UNAVAILABLE;
+ (nullable instancetype)sequenceWithSequenceInstructions:(nonnull NSArray<FNGitSequenceInstruction *> *)sequenceInstructions;

- (nullable instancetype)init NS_UNAVAILABLE;
- (nullable instancetype)initWithSequenceInstructions:(nonnull NSArray<FNGitSequenceInstruction *> *)sequenceInstructions;

- (BOOL)createGitSequenceEditorScriptAtURL:(nonnull NSURL *)fileURL error:(NSError * _Nullable __autoreleasing * _Nullable)error;

@end
