//
//  GitHubAccount.h
//  GitHubAPI
//
//  Created by Alexander Rinass on 19.06.12.
//  Copyright (c) 2012 Fournova GmbH. All rights reserved.
//

#import <FNFoundation/FNFoundation.h>

extern NSString *const GitHubAPIAccountTypeUser;
extern NSString *const GitHubAPIAccountTypeOrganization;

@class GitHubAPIPlan;
@interface GitHubAPIAccount : FNRESTAPIModel
@property (nonatomic, readonly) NSInteger accountID;
@property (nonatomic, readonly) NSString *login;
@property (nonatomic, readonly) NSString *type;
@property (nonatomic) NSString *name;
@property (nonatomic) NSString *email;
@property (nonatomic) NSString *company;
@property (nonatomic) NSString *blog;
@property (nonatomic) NSString *location;
@property (nonatomic, getter = isHireable) BOOL hireable;
@property (nonatomic) NSString *bio;
@property (nonatomic, readonly) NSURL *avatarURL;
@property (nonatomic, readonly) NSString *gravatarID;
@property (nonatomic, readonly) NSURL *apiURL;
@property (nonatomic, readonly) NSURL *webURL;
@property (nonatomic, readonly) NSInteger followers;
@property (nonatomic, readonly) NSInteger following;
@property (nonatomic, readonly) NSInteger publicRepositories;
@property (nonatomic, readonly) NSInteger publicGists;
@property (nonatomic, readonly) NSInteger totalPrivateRepos;
@property (nonatomic, readonly) NSInteger ownedPrivateRepos;
@property (nonatomic, readonly) NSInteger privateGists;
@property (nonatomic, readonly) NSInteger diskUsage;
@property (nonatomic, readonly) GitHubAPIPlan *plan;
@property (nonatomic, readonly) NSDate *creationDate;

+ (instancetype)accountWithJSONObject:(NSDictionary *)JSONObject;

- (BOOL)isEqualToGitHubAPIAccount:(GitHubAPIAccount *)object;

@end
