//
//  GitHubCreatePublicKeyAPIRequestOperation.h
//  GitHubAPI
//
//  Created by Alexander Rinass on 20.06.12.
//  Copyright (c) 2012 Fournova GmbH. All rights reserved.
//

#import "GitHubAPIRequestOperation.h"

@class GitHubAPIPublicKey;
@interface GitHubAPICreatePublicKeyRequestOperation : GitHubAPIRequestOperation
@property (nonatomic, readonly) GitHubAPIPublicKey *publicKey;
@property (nonatomic, readonly) GitHubAPIPublicKey *createdPublicKey;

+ (instancetype)requestWithCredentials:(GitHubAPICredentials *)credentials publicKey:(GitHubAPIPublicKey *)publicKey;
- (instancetype)initWithCredentials:(GitHubAPICredentials *)credentials publicKey:(GitHubAPIPublicKey *)publicKey;

@end
