//
//  GitHubCreateRepositoryAPIRequestOperation.h
//  GitHubAPI
//
//  Created by Alexander Rinass on 20.06.12.
//  Copyright (c) 2012 Fournova GmbH. All rights reserved.
//

#import "GitHubAPIRequestOperation.h"

@class GitHubAPIRepository;
@interface GitHubAPICreateRepositoryRequestOperation : GitHubAPIRequestOperation
@property (nonatomic, readonly) GitHubAPIRepository *repository;
@property (nonatomic, readonly) NSString *organizationName;
@property (nonatomic, readonly) GitHubAPIRepository *createdRepository;

+ (instancetype)requestWithCredentials:(GitHubAPICredentials *)credentials repository:(GitHubAPIRepository *)repository;
+ (instancetype)requestWithCredentials:(GitHubAPICredentials *)credentials repository:(GitHubAPIRepository *)repository organizationName:(NSString *)organizationName;
- (instancetype)initWithCredentials:(GitHubAPICredentials *)credentials repository:(GitHubAPIRepository *)repository organizationName:(NSString *)organizationName;

@end
