//
//  GitHubFetchRepositoriesAPIRequestOperation.h
//  GitHubAPI
//
//  Created by Alexander Rinass on 20.06.12.
//  Copyright (c) 2012 Fournova GmbH. All rights reserved.
//

#import "GitHubAPIRequestOperation.h"

@interface GitHubAPIFetchRepositoriesRequestOperation : GitHubAPIRequestOperation
@property (nonatomic, readonly) NSString *accountName;
@property (nonatomic, readonly) NSString *organizationName;
@property (nonatomic, readonly) NSArray *repositories;
@property (nonatomic, readonly) NSDictionary *options;

+ (instancetype)requestWithCredentials:(GitHubAPICredentials *)credentials options:(NSDictionary *)options;
+ (instancetype)requestWithCredentials:(GitHubAPICredentials *)credentials accountName:(NSString *)accountName options:(NSDictionary *)options;
+ (instancetype)requestWithCredentials:(GitHubAPICredentials *)credentials organizationName:(NSString *)organizationName options:(NSDictionary *)options;

- (instancetype)initWithCredentials:(GitHubAPICredentials *)credentials accountName:(NSString *)accountName organizationName:(NSString *)organizationName options:(NSDictionary *)options;

@end
