//
//  GitHubFetchRepositoryAPIRequestOperation.h
//  GitHubAPI
//
//  Created by Alexander Rinass on 20.06.12.
//  Copyright (c) 2012 Fournova GmbH. All rights reserved.
//

#import "GitHubAPIRequestOperation.h"

@class GitHubAPIRepository;

@interface GitHubAPIFetchRepositoryRequestOperation : GitHubAPIRequestOperation
@property (nonatomic, readonly) NSString *accountName;
@property (nonatomic, readonly) NSString *repositoryName;
@property (nonatomic, readonly) GitHubAPIRepository *repository;

+ (instancetype)requestWithCredentials:(GitHubAPICredentials *)credentials fullRepositoryName:(NSString *)fullRepositoryName;
+ (instancetype)requestWithCredentials:(GitHubAPICredentials *)credentials repositoryName:(NSString *)repositoryName;
+ (instancetype)requestWithCredentials:(GitHubAPICredentials *)credentials accountName:(NSString *)accountName repositoryName:(NSString *)repositoryName;

- (instancetype)initWithCredentials:(GitHubAPICredentials *)credentials accountName:(NSString *)accountName repositoryName:(NSString *)repositoryName;

@end
