//
//  GitHubAPIHelpers.h
//  GitHubAPI
//
//  Created by Alexander Rinass on 08.02.13.
//  Copyright (c) 2013 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface GitHubAPIHelpers : NSObject

/** @name Creating API URLs */

+ (NSURL *)APIHostURL;

+ (NSURL *)makeAPIURLWithResourcePath:(NSString *)resourcePath params:(NSDictionary *)params;
+ (NSURL *)makeAPIURLWithHost:(NSString *)host resourcePath:(NSString *)resourcePath params:(NSDictionary *)params;

+ (NSDictionary *)makeAPIRequestParamsWithOptions:(NSDictionary *)options defaultOptions:(NSDictionary *)defaultOptions;

/** @name Generating User API Resource Paths */

+ (NSString *)userAPIResourcePath;
+ (NSString *)userAPIResourcePathWithUsername:(NSString *)username;

/** @name Generating Repository API Resource Paths */

+ (NSString *)repositoriesAPIResourcePath;
+ (NSString *)repositoriesAPIResourcePathWithUsername:(NSString *)username;
+ (NSString *)repositoryAPIResourcePathWithAccountName:(NSString *)accountName repositoryName:(NSString *)repositoryName;
+ (NSString *)repositoriesAPIResourcePathWithOrganizationName:(NSString *)organizationName;

/** @name Generating Public Key API Resource Paths */

+ (NSString *)publicKeysAPIResourcePath;
+ (NSString *)publicKeyAPIResourcePathWithPublicKeyID:(NSInteger)publicKeyID;

/** @name Generating Organization API Resource Paths */

+ (NSString *)organizationsAPIResourcePath;
+ (NSString *)organizationsAPIResourcePathWithUsername:(NSString *)username;
+ (NSString *)organizationAPIResourcePathWithOrganizationName:(NSString *)organizationName;

/** @name Querying Git Remote URLs */

+ (NSString *)accountNameFromRemoteURL:(NSURL *)remoteURL;
+ (NSString *)repositoryNameFromRemoteURL:(NSURL *)remoteURL;

/** @name Creating Web URLs */

+ (NSURL *)userWebURLForAccount:(NSString *)accountName;
+ (NSURL *)repositoryWebURLForAccount:(NSString *)accountName repository:(NSString *)repositoryName;

+ (NSURL *)userWebURLForAccount:(NSString *)accountName host:(NSString *)host;
+ (NSURL *)repositoryWebURLForAccount:(NSString *)accountName repository:(NSString *)repositoryName host:(NSString *)host;

/** @name Access Token Helpers */

+ (BOOL)isToken:(NSString *)token equalToHashedToken:(NSString *)hashedToken;

@end
