//
//  NSError+BeanstalkAPI.h
//  BeanstalkAPI
//
//  Created by Alexander Rinaß on 14.06.12.
//  Copyright (c) 2012 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

extern NSString *const BeanstalkAPIErrorDomain;

extern NSString *const BeanstalkAPIRequestURLErrorKey;
extern NSString *const BeanstalkAPIRequestPathErrorKey;
extern NSString *const BeanstalkAPIRequestBodyErrorKey;
extern NSString *const BeanstalkAPIRequestHeadersErrorKey;

extern NSString *const BeanstalkAPIResponseStatusCodeErrorKey;
extern NSString *const BeanstalkAPIResponseHeadersErrorKey;
extern NSString *const BeanstalkAPIResponseBodyErrorKey;

extern NSString *const BeanstalkAPIErrorMessageErrorKey;

enum {
    BeanstalkAPIGenericError = 1, // Generic API Error
    BeanstalkAPIConnectionError,
    BeanstalkAPIParseError,
    
    BeanstalkAPIBadRequestError = 400,
    BeanstalkAPIAuthenticationError = 401,
    BeanstalkAPIForbiddenError = 403,
    BeanstalkAPINotFoundError = 404,
    BeanstalkAPIServerError = 500
};

@interface NSError (BeanstalkAPI)

+ (instancetype)beanstalkAPIErrorWithCode:(NSInteger)code userInfo:(NSDictionary *)userInfo;
+ (instancetype)beanstalkAPIConnectionErrorWithNSURLError:(NSError *)NSURLError userInfo:(NSDictionary *)userInfo;
+ (instancetype)beanstalkAPIParseErrorWithError:(NSError *)error userInfo:(NSDictionary *)userInfo;

@end
