//
//  BitbucketAPIHelpers.h
//  BitbucketAPI
//
//  Created by Marc Beyerlin on 04.07.13.
//  Copyright (c) 2013 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface BitbucketAPIHelpers : NSObject

/** @name Generating API URIs */

+ (NSURL *)APIHostURL;

+ (NSURL *)makeAPIURLWithResourcePath:(NSString *)resourcePath params:(NSDictionary *)params;
+ (NSString *)makeAPIResourcePathWithPathComponents:(NSArray *)pathComponents;
+ (NSDictionary *)makeAPIRequestParamsWithOptions:(NSDictionary *)options defaultOptions:(NSDictionary *)defaultOptions;

/** @name Generating User API Resource Paths */

+ (NSString *)userAPIResourcePath;
+ (NSString *)userAPIResourcePathWithUsername:(NSString *)username;

/** @name Generating Repository API Resource Paths */

+ (NSString *)repositoriesAPIResourcePath;
+ (NSString *)repositoriesAPIResourcePathWithUsername:(NSString *)username;
+ (NSString *)repositoryAPIResourcePathWithUsername:(NSString *)username repositoryName:(NSString *)repositoryName;

/** @name Generating Team API Resource Paths */

+ (NSString *)teamsAPIResourcePath;
+ (NSString *)teamAPIResourcePathWithName:(NSString *)teamName;

/** @name Generating Web URLs */

+ (NSURL *)userWebURLForUser:(NSString *)userName;
+ (NSURL *)repositoryWebURLForUser:(NSString *)userName repository:(NSString *)repositoryName;

/** @name Querying Remote URLs */

+ (NSString *)userNameFromRemoteURL:(NSURL *)remoteURL;
+ (NSString *)repositoryNameFromRemoteURL:(NSURL *)remoteURL;

@end
