//
//  FNAppInitializer.h
//  FNAppKit
//
//  Created by Alexander Rinass on 20/01/16.
//  Copyright © 2016 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "FNAppInitializing.h"

@interface FNAppInitializer : NSObject
@property (nonatomic, readonly, getter = isInitialized) BOOL initialized;
@property (nonatomic, readonly, nullable) NSError *error;
@property (nonatomic, readonly, nonnull) NSArray *initializers;

+ (nonnull instancetype)defaultInitializer;

- (void)addInitializer:(nonnull id<FNAppInitializing>)initializer;
- (void)removeInitializer:(nonnull id<FNAppInitializing>)initializer;
- (void)removeAllInitializers;

- (BOOL)initialize:(NSError * __nullable __autoreleasing * __nullable)error;
- (void)uninitialize;

@end
