//
//  FNRESTAPIRequest.h
//  FNFoundation
//
//  Created by Alexander Rinass on 27/05/15.
//  Copyright (c) 2015 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@class FNRESTAPIRequestOperation;
@interface FNRESTAPIRequest : NSObject
@property (nonatomic, readonly) NSURL *URL;
@property (nonatomic, readonly) NSDictionary *headers;
@property (nonatomic, readonly) NSString *body;
@property (nonatomic, readonly, getter=isLoading) BOOL loading;
@property (nonatomic, readonly, getter=isCancelled) BOOL cancelled;

- (instancetype)initWithRequestOperation:(FNRESTAPIRequestOperation *)requestOperation;

- (void)cancel;
- (void)waitUntilFinished;

@end
