//
//  NSURL+FNCommon.h
//  FNFoundation
//
//  Created by Alexander Rinaß on 20.02.12.
//  Copyright (c) 2012 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface NSURL (FNCommon)

+ (NSURL *)URLWithScheme:(NSString *)scheme host:(NSString *)host port:(NSNumber *)port path:(NSString *)path;

- (NSURL *)URLBySettingUser:(NSString *)user;
- (NSURL *)URLByRemovingUser;

- (NSURL *)URLByDeletingPath __deprecated;
- (NSURL *)URLByDeletingPathAndQueryString;

- (NSURL *)URLByAppendingQueryParams:(NSDictionary *)params;

@property (nonatomic, readonly, getter=isValidWebURL) BOOL validWebURL;

@end
