//
//  NSURL+Normalization.h
//  FNFoundation
//
//  Created by Alexander Rinass on 28/07/16.
//  Copyright © 2016 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface NSURL (Normalization)

@property (nonatomic, nonnull, readonly) NSURL *URLByNormalizingPath;

/**
 Normalizes a local file URL by standardizing its path. Trailing slashes are
 appended automatically by the NSURL's `initFileURLWithPath:isDirectory:`.

 If the receiver is not a file URL, the URL is returned unaltered.
 */
@property (nonatomic, nonnull, readonly) NSURL *normalizedFileURL;

/**
 Normalizes a local file URL by standardizing its path and does not append
 a trailing slash (using NSURL's `initFileURLWithPath:isDirectory:` with `NO` for
 `ìsDirectory` param).
 
 If the receiver is not a file URL, the URL is returned unaltered.
 */
@property (nonatomic, nonnull, readonly) NSURL *normalizedFileTypeFileURL;

/**
 Normalizes a local file URL by standardizing its path and enfores a trailing
 slash (using NSURL's `initFileURLWithPath:isDirectory:` with `YES` for
 `ìsDirectory` param).
 
 If the receiver is not a file URL, the URL is returned unaltered.
 */
@property (nonatomic, nonnull, readonly) NSURL *normalizedDirectoryTypeFileURL;

@end
