//
//  FNGitSubmoduleConfig.h
//  FNGit
//
//  Created by Alexander Rinass on 12.08.13.
//  Copyright (c) 2013 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "FNGitSubmoduleConfigType.h"
#import "FNGitSubmoduleIgnoreMode.h"
#import "FNGitSubmoduleUpdateStrategy.h"
#import "FNGitSubmoduleRecurseSubmodulesOption.h"

extern NSString *const FNGitSubmoduleConfigKeyURL;
extern NSString *const FNGitSubmoduleConfigKeyPath;
extern NSString *const FNGitSubmoduleConfigKeyUpdate;
extern NSString *const FNGitSubmoduleConfigKeyBranch;
extern NSString *const FNGitSubmoduleConfigKeyFetchRecurseSubmodules;
extern NSString *const FNGitSubmoduleConfigKeyIgnore;

@class FNGitRepository;
@interface FNGitSubmoduleConfig : NSObject
@property (nonatomic, readonly) FNGitRepository *repository;
@property (nonatomic, readonly) FNGitSubmoduleConfigType configType;
@property (nonatomic, readonly) NSString *path;
@property (nonatomic, readonly) NSString *name;
@property (nonatomic, readonly) NSString *URL;
@property (nonatomic, readonly) FNGitSubmoduleUpdateStrategy updateStrategy;
@property (nonatomic, readonly) FNGitSubmoduleStatusIgnoreMode statusIgnoreMode;
@property (nonatomic, readonly) FNGitSubmoduleRecurseSubmodulesOption recurseSubmodules;
@property (nonatomic, readonly) NSString *branch;

/** @name Creating Objects */

+ (instancetype)submoduleConfigWithRepository:(FNGitRepository *)repository configType:(FNGitSubmoduleConfigType)configType name:(NSString *)submoduleName values:(NSDictionary *)values;
- (instancetype)initWithRepository:(FNGitRepository *)repository configType:(FNGitSubmoduleConfigType)configType name:(NSString *)submoduleName values:(NSDictionary *)values;

/** @name Accessing String Values */

- (NSString *)configValueForKey:(NSString *)configKey;

@end
