//
//  GitHubAPIApp.h
//  GitHubAPI
//
//  Created by Alexander Rinass on 04/05/15.
//  Copyright (c) 2015 Fournova GmbH. All rights reserved.
//

#import <FNFoundation/FNFoundation.h>

@interface GitHubAPIApp : FNRESTAPIModel
@property (nonatomic, readonly) NSString *clientID;
@property (nonatomic, readonly) NSString *clientSecret;
@property (nonatomic, readonly) NSString *name;
@property (nonatomic, readonly) NSURL *URL;

+ (instancetype)appWithClientID:(NSString *)clientID clientSecret:(NSString *)clientSecret;
+ (instancetype)appWithClientID:(NSString *)clientID clientSecret:(NSString *)clientSecret name:(NSString *)name URL:(NSURL *)URL;

+ (instancetype)appWithJSONObject:(NSDictionary *)JSONObject;

- (BOOL)isEqualToGitHubAPIApp:(GitHubAPIApp *)object;

@end
