//
//  GitHubAPIResetAuthorizationRequestOperation.h
//  GitHubAPI
//
//  Created by Alexander Rinass on 16/06/15.
//  Copyright (c) 2015 Fournova GmbH. All rights reserved.
//

#import "GitHubAPIRequestOperation.h"

@class GitHubAPIAuthorization;
@interface GitHubAPIResetAuthorizationRequestOperation : GitHubAPIRequestOperation
@property (nonatomic, readonly) NSString *accessToken;
@property (nonatomic, readonly) NSString *clientID;
@property (nonatomic, readonly) GitHubAPIAuthorization *authorization;

+ (instancetype)requestWithCredentials:(GitHubAPICredentials *)credentials clientID:(NSString *)clientID accessToken:(NSString *)accessToken;
- (instancetype)initWithCredentials:(GitHubAPICredentials *)credentials clientID:(NSString *)clientID accessToken:(NSString *)accessToken;

@end
