//
//  File.swift
//  
//
//  Created by Ana Centea on 16.07.2024.
//

import Foundation

public class GraphiteRepositoryBuilder: Identifiable {
    public let id = UUID()
    public var mainBranch: String = "main"
    public var commands: [String] = []
    
    public init() { }
}

public extension GraphiteRepositoryBuilder {
    func setParent(for branch: String, parent: String) {
        commands.append("gt track \(branch) --parent=\(parent) --no-interactive")
    }
    
    func untrack(branch: String) {
        commands.append("gt untrack \(branch) --no-interactive")
    }
    
    func changeTrunk(to branch: String) {
        commands.append("gt init --trunk=\(branch) --no-interactive")
    }
}
