//
//  File.swift
//  
//
//  Created by Ana Centea on 16.07.2024.
//

import Foundation

import Foundation
import GitTest

extension Repository {
    public static func create(createMasterBranch: Bool = true, repoName: String? = nil, _ block: (GitTest.RepositoryBuilder) -> Void) throws -> Repository {
        let builder = GitTest.RepositoryBuilder(repoName: repoName)
        builder.createMasterBranch = createMasterBranch
        block(builder)
        let testRepo = try GitTest.Repository.create(fromBuilder: builder)
        let repository = Repository(workingTreeUrl: testRepo.fileURL)
        return repository;
    }

    public func update(_ block: (GitTest.RepositoryBuilder) -> Void) throws {
        let builder = GitTest.RepositoryBuilder()
        block(builder)
        let testRepository = GitTest.Repository(fileURL: workingTreeDirectory)
        try testRepository.update(fromBuilder: builder)
    }
}
