# Release Notes - Version 15

For a complete list of all changes, improvements, and bug fixes, please visit [our release notes page](https://www.git-tower.com/release-notes/mac).

### New 
- macOS 26 Tahoe: Tower now fully supports the new operating system.
- App Icon: Added new app icon for macOS 26!
- Automatic Branch Management: You can now archive fully merged and stale branches either manually or let Tower do the job for you.
- History: The history now clearly shows which commits are introduced by a branch relative to its parent (fork point).
- History: A hint view is displayed for fully merged and stale branches, allowing quick archival or deletion of these branches.
- Sidebar: Branches in the sidebar are now marked as fully merged or stale.
- Sidebar: View settings are now easily accessible via the footer.

### Improved
- Pinned Branches: Pinned branches now are stored in the Git config and should not unpin anymore.
- Pinned Branches: You can now pin and unpin multiple branches at once.
- Pinned Branches: The "Pinned Branches" section in the sidebar is now automatically expanded.
- Pinned Branches: Undoing a branch delete now restores the pinned flag correctly.
- Sorting: Text is now sorted in many views via a localized standard compare to match system behavior.
- Commit Signing: Tower now handles SSH keys without a comment correctly.
- Branches: The update branch dialog now remembers the last decision for the update strategy if none is defined by a workflow.
- Branches: Branches newly created in Tower are not marked as fully merged anymore.
- Sidebar: The auto-archive option has been added to the sidebar view settings.
- Sidebar: The archive button in the sidebar footer is now hidden when auto-archive is active.
- Sidebar: Sidebar footer buttons no longer overlap with the filter text field.
- Sidebar: Repository sidebar filter text field no longer automatically becomes active on hover.
- Sidebar: Fully merged and stale badges are no longer displayed for detached branches.
- Branches: Auto-archive option no longer archives immediately when selected in dialog.
- Branches: Improved branch unarchiving to always set "Skips Auto-Archive" flag.
- Graphite: Optimized Graphite state update performance.
- Branches: The update branch action is now available in the context menu and quick actions.
- Workflows: The "Finish Topic Branch" dialog now automatically selects the current HEAD branch if it is a topic branch and the action was performed without a branch selection.
- License Activation: Activation with pasted email and license code works as expected now.

### Fixed
- Merge/Rebase: Tower could crash when using Quick Merge or Rebase. This has been fixed.
- History: A crash could occur when searching for whitespaces. This is fixed now.
- Worktrees: In some cases Tower could crash when accessing worktrees. It's working now.
- Reset Revision: The text field did not allow entering arbitrary revisions anymore. It does allow them again now.
- Merge Conflict: The merge conflict wizard now allows resolving a "both deleted" conflict again.
- Sidebar: The performance of reloading branches has been improved.
- Repository: A crash when updating the statistics of the repository has been fixed.
- History: A layout problem has been solved in drawing the commit graph if there only is a single commit.
- Performance: Tower could slow down in repositories with many branches. This has been fixed.
- Tower could crash when updating repository information. This has been fixed.
- Fixed crash when clicking workflow toolbar button before branches are loaded.
- Fixed crash when creating branches.
- Fixed crash when the Quick Start window would display deleted repositories.
- Fixed crash when pinning or restoring branches in worktrees.
- Fixed branch tooltip showing incorrect stale date in sidebar.
- Fixed commit graph being drawn into section header.
- Fixed update-branch dialog mergeability states not showing correctly.
- Fixed "No parent branch set" shown instead of loading state in update dialog.
- Fixed update button not being enabled when it should be in update branch dialog.
- Branches: Branches with uppercase characters do not unpin or unarchive immediately anymore.
- Workflows: The "Starting Point" menu now displays all available refs in the "Start Topic Branch" dialog.
- Workflows: The text fields in "Start Topic Branch" dialog will now confirm the dialog if possible when pressing "Return".
- History: Active searches are now applied when bringing Tower to the foreground again.
- History: A layout issue has been resolved that occurred when displaying multiple search filters.
